<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    
    <!--
        
        This XSL Library is to verify if user defined directories and files are set with required file permissions.
        
        <criteria operator="OR">
        <criterion comment="Test for the existence of the script file" negate="true" test_ref="oval:com.mcafee.oval:tst:1163060"/>
        <criterion comment="Test the owner of the script file" test_ref="oval:com.mcafee.oval:tst:1163061"/>
        </criteria>
        
        <variables>
        <external_variable id='oval:com.mcafee.oval:var:1163128' version='1' datatype='string' comment='What is the path for script file ?' />
        <external_variable id='oval:com.mcafee.oval:var:1163129' version='1' datatype='string' comment='What is the name of script file ?' />
        <external_variable comment="What is the required User ID of the file owner" datatype="int" id="oval:com.mcafee.oval:var:80228" version="4" />
        </variables>
        
        Ex. OVAL ID - oval:com.mcafee.oval:def:1163040
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getOwnerTypeFromTitle">
        <xsl:param name="title"/>
        <xsl:variable name="subTitle">
            <xsl:if test="contains($title, '-' )">
                <xsl:value-of select="substring-before($title, '-' )"/>
            </xsl:if>
        </xsl:variable>
        
        <xsl:variable name="ownerType">
            <xsl:choose>            
                <xsl:when test="contains($subTitle, 'group' )">
                    <xsl:text>group</xsl:text>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:text>user</xsl:text>
                </xsl:otherwise>
            </xsl:choose>            
        </xsl:variable>        
        <xsl:choose>            
            <xsl:when test="$ownerType != '' ">
                <xsl:value-of select="$ownerType"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        
        <!-- Collect all results for the criterias in the variables ......................................... --> 
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[1]/@result"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@result"/>        
        <xsl:variable name="testId" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[2]/@test_ref"/>
        
        <!-- Check which kind of owner permissions are being tested in this check ........................................................................................... -->
        <xsl:variable name="ownerType">
            <xsl:call-template name="getOwnerTypeFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>                
        </xsl:variable>
        
        <xsl:variable name="testedVar" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]"/>
        
        <!--  Extract input value -->
        <xsl:variable name="externalVarValue">
            <xsl:choose>
                <xsl:when test="contains($ownerType, 'group') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[3]"/>                                             
                </xsl:when>
                <xsl:when test="contains($ownerType,'user') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[3]"/>
                </xsl:when>
            </xsl:choose>           
        </xsl:variable>             
        
        <xsl:variable name="externalVarValue2">
            <xsl:choose>
                <xsl:when test="contains($ownerType, 'group') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[2]"/>                                             
                </xsl:when>
                <xsl:when test="contains($ownerType,'user') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[2]"/>
                </xsl:when>
            </xsl:choose>           
        </xsl:variable>             
        
        <xsl:variable name="externalVarValue1">
            <xsl:choose>
                <xsl:when test="contains($ownerType, 'group') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[1]"/>                                             
                </xsl:when>
                <xsl:when test="contains($ownerType,'user') ">
                    <xsl:value-of select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable[1]"/>
                </xsl:when>
            </xsl:choose>           
        </xsl:variable>          
        
        <xsl:variable name="testedVarCount">
            <xsl:value-of select="count(/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_variable)"/>
        </xsl:variable>        
        <xsl:variable name="fileItemCount">
            <xsl:value-of select="count(/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item)"/>
        </xsl:variable>        
        
        
        
        <!-- Verify the actual permissions value existing on the system........................................................................................... -->
        <xsl:variable name="fileTestItem_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$testId]/oval-res:tested_item/@item_id"/>
        <xsl:variable name="item" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:file_item[@id=$fileTestItem_id]"/>        
        
        <!-- Extract actual value -->
        <xsl:variable name="systemValue">
            <xsl:choose>
                <xsl:when test="contains($ownerType, 'group') ">
                    <xsl:value-of select="$item/unix-sc:group_id/text()"/>                                             
                </xsl:when>
                <xsl:when test="contains($ownerType,'user') ">
                    <xsl:value-of select="$item/unix-sc:user_id/text()"/>
                </xsl:when>
            </xsl:choose>           
        </xsl:variable>
        
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <!-- Also if permissions are being checked for single file or directory then actual values will also be displayed to user and if multiple files/directories are
            being tested for permissions then general message will be displayed without actual valuese -->
        
        <xsl:variable name="message_id">
            <xsl:choose>
                <!-- if number of file item is one then display specific message with actual values -->
                <xsl:when test="$fileItemCount = 1">
                    <!-- Check if result is false ........................................................................................... -->
                    <xsl:if test="$result='false'">
                        <xsl:choose>
                            <xsl:when test="$result1 = 'false' and $result2 = 'false' ">
                                <xsl:choose>
                                    <xsl:when test="contains($ownerType, 'group' )">
                                        <xsl:text>com.mcafee.pa.msg.FileGroupOwnerValidAnyFileExt</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="contains($ownerType, 'user') ">
                                        <xsl:text>com.mcafee.pa.msg.FileUserOwnerValidAnyFileExt</xsl:text>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                    <!-- Check if result is true ........................................................................................... -->
                    <xsl:if test="$result='true'">
                        <xsl:choose>
                            <xsl:when test="$result1 = 'true' ">
                                <xsl:text>com.mcafee.pa.msg.FileDoesNotExistAnyFileExt</xsl:text>
                            </xsl:when>
                            <xsl:when test="$result1 = 'false' and $result2 = 'true' ">
                                <xsl:choose>
                                    <xsl:when test="contains($ownerType, 'group') ">
                                        <xsl:text>com.mcafee.pa.msg.FileGroupOwnerValidAnyFileExt</xsl:text>
                                    </xsl:when>
                                    <xsl:when test="contains($ownerType, 'user' ) ">
                                        <xsl:text>com.mcafee.pa.msg.FileUserOwnerValidAnyFileExt</xsl:text>
                                    </xsl:when>
                                </xsl:choose>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:if>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>                                              
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>                                              
                </xsl:when>
            </xsl:choose>               
        </xsl:variable>
                
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2" >
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">UserValue</xsl:attribute>
                    <xsl:value-of select="$externalVarValue"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">DirectoryPath</xsl:attribute>
                    <xsl:value-of select="$externalVarValue1"/>
                </xsl:element>  
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">SystemValue</xsl:attribute>
                    <xsl:value-of select="$systemValue"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">FileName</xsl:attribute>
                    <xsl:value-of select="$externalVarValue2"/>
                </xsl:element>         
            </xsl:element>
        </xsl:element>
        
    </xsl:template>
</xsl:stylesheet>