<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:aix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#aix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:aix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#aix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    xmlns:xalan="http://xml.apache.org/xalan"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def aix-def aix-sc">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
        
    <!-- This library works fine for the inetd checks with below logic and is the modified v ersion of  LinuxInetdServiceChecks.xsl
        
        ===========================================================================
        This library has following test cases:
        1. INPUT=enable, SYSTEM Setting=enable (Inetd is installed and service is enabled), Final result=TRUE 
        2. INPUT=disable, SYSTEM Setting=disable (Inetd is installed and service is disabled), Final result=TRUE 
        3. INPUT=enable, SYSTEM Setting=disable (Inetd is installed and service is disabled), Final result=FALSE
        4. INPUT=disable, SYSTEM Setting=enable (Inetd is installed and service is enabled), Final result=FALSE
        5. INPUT=disable, SYSTEM Setting=Inetd is not installed (disable), Final result=TRUE
        6. INPUT=enable, SYSTEM Setting=Inetd is not installed (disable), Final result=FALSE
        ===========================================================================
        
        This library works fine for the below check logic:
        
        <criteria operator="OR">
            <criteria operator="AND">
                <criterion test_ref="oval:com.mcafee.oval:tst:227134" comment='External Variable set Disabled' />
                <criteria operator="AND" negate="true">
                    <criterion comment='Test for the existence of the file - /etc/inetd.conf' test_ref='oval:com.mcafee.oval:tst:99493' />
                    <criterion test_ref="oval:com.mcafee.oval:tst:236350" comment="Verify if all the inetd based services are disabled in /etc/inetd.conf file" />
                </criteria>
            </criteria>
            <criteria operator="AND">
                <criterion negate="true" test_ref="oval:com.mcafee.oval:tst:227134" comment='External Variable set Disabled' />
                <criteria operator="AND">
                    <criterion comment='Test for the existence of the file - /etc/inetd.conf' test_ref='oval:com.mcafee.oval:tst:99493' />
                    <criterion test_ref="oval:com.mcafee.oval:tst:236350" comment="Verify if all the inetd based services are disabled in /etc/inetd.conf file" />
                </criteria>
            </criteria>
        </criteria>
        
        Example def if : oval:com.mcafee.oval:def:236349
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
  
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
         <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
        <!-- Collect service name from the title ......................................... --> 
        <xsl:variable name="Definitions" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions"/>
        <xsl:variable name="title" select="$Definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
       
        <xsl:variable name="inetdTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:inetd_test/@id"/>
        <xsl:variable name="inetdTestResult">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test">
                <xsl:if test="@test_id=$inetdTest_id">
                    <xsl:value-of select="@result"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="inetdServList">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test[@test_id=$inetdTest_id]">
                <xsl:variable name="itemRef" select="oval-res:tested_item/@item_id"/>
                    <xsl:variable name="inetdTestItem" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/unix-sc:inetd_item[@id=$itemRef]" />
                    <xsl:if test="not($inetdTestItem/@status)">
                        <xsl:value-of select="concat($inetdTestItem/unix-sc:service_name/text(),' ', '(', $inetdTestItem/unix-sc:protocol/text(),')', '      ')"/>    
                    </xsl:if>
                </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="fileTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test/@id"/>
        <xsl:variable name="fileTestResult">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test">
              <xsl:if test="@test_id=$fileTest_id">
                  <xsl:value-of select="@result"/>
              </xsl:if>
            </xsl:for-each>
        </xsl:variable>
        
        <xsl:variable name="varTest_id" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:variable_test/@id"/>
        <xsl:variable name="varTestResult">
            <xsl:for-each select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:tests/oval-res:test">
                <xsl:if test="@test_id=$varTest_id">
                    <xsl:value-of select="@result"/>
                </xsl:if>
            </xsl:for-each>
        </xsl:variable>
                
        <!-- Decide about the message id depending upon  the combination of results for various criterions ........................................................................................... -->
        <xsl:variable name="message_id">
            <!-- Check if result is true ........................................................................................... -->
            <xsl:if test="$result='true'">
                <xsl:choose>
                    <xsl:when test="$varTestResult = 'true' and $fileTestResult='true' and $inetdTestResult='false'">
                        <xsl:text>com.mcafee.pa.msg.linuxInetdAllDisabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$varTestResult = 'false' and $fileTestResult='true' and $inetdTestResult='true'">
                        <xsl:text>com.mcafee.pa.msg.linuxInetdAllEnabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$varTestResult = 'true' and $fileTestResult='false'">
                        <xsl:text>com.mcafee.pa.msg.InetdStatusSCAP</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.PatternMatchSCAP</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- Check if result is false ........................................................................................... -->
            <xsl:if test="$result='false'">
                <xsl:choose>
                    <xsl:when test="$varTestResult = 'true' and $fileTestResult='true' and $inetdTestResult='true'">
                        <xsl:text>com.mcafee.pa.msg.linuxInetdAllDisabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$varTestResult = 'false' and $fileTestResult='true' and $inetdTestResult='false'">
                        <xsl:text>com.mcafee.pa.msg.linuxInetdAllEnabled</xsl:text>
                    </xsl:when>
                    <xsl:when test="$varTestResult = 'false' and $fileTestResult='false'">
                        <xsl:text>com.mcafee.pa.msg.linuxInetdExpEnabled</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>com.mcafee.pa.msg.configGenericSCAP</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>  
        </xsl:variable>
        
        <xsl:variable name="isViolationValue">
            <xsl:choose>
                <xsl:when test="$result = 'false' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>false</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
     
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">config_name</xsl:attribute>
                    <xsl:value-of select="$title"/>
                </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">service_list</xsl:attribute>
                    <xsl:value-of select="$inetdServList"/>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>