<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    xmlns:ind-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#independent"
    xmlns:ind-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#independent"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def ind-sc ind-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <!--
        
        This XSL is to verify if application patch is installed on the sysytem
        
        <criteria  operator="AND" comment="This test will check the negative condition for Adobe Reader is installed and return fail if version is less than 10.1.2">
        <criterion comment="Adobe Reader 10.x for Mac is Present" test_ref="oval:com.mcafee.oval:tst:403616"/> #textfilecontent54#
        <criterion comment="Adobe Reader Product Version is less than 10.1.2" test_ref="oval:com.mcafee.oval:tst:227490"/> #textfilecontent54#
        </criteria>
        
        or 
        
        <criteria operator='AND' comment="This test will check the condition that if Adobe Flash Player is installed and version is less than 10.1.102.64  on Mac return fail" >
        <criterion comment="Adobe Flash Player 10.x installed on Mac" test_ref="oval:com.mcafee.oval:tst:404842"/>
        <criterion comment="Adobe Flash Player version is less than 10.1.102.64 on Mac" test_ref="oval:com.mcafee.oval:tst:212708"/>
        </criteria>
        
        Ex OVAl ID : oval:com.mcafee.oval:def:229945, oval:com.mcafee.oval:def:227484, 
        oval:com.mcafee.oval:def:87691, oval:com.mcafee.oval:def:242079, oval:com.mcafee.oval:def:212706 and simillar kind of logic ones
        
    -->
    
    <xsl:param name="defid" />
    <xsl:template match="/">
        <xsl:call-template name="getFindings">
            <xsl:with-param name="definitionId" select="$defid"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="getProductNameFromTitle">
        <xsl:param name="title"/>
        <xsl:variable name="product">
            <xsl:choose>       
            <xsl:when test="contains($title,'Reader')">
                <xsl:value-of select="concat('Adobe Reader',substring-before(substring-after($title,'Update'),'.'))"/>
            </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat('Adobe Flash Player',substring-before(substring-after($title,'Update'),'.'))"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:choose>            
            <xsl:when test="$product != '' ">
                <xsl:value-of select="$product"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$title"/>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    
    <xsl:template name="getFindings">
        <xsl:param name="definitionId"/>
      
        <xsl:variable name="title" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:definitions/oval-def:definition[ @id = $definitionId ]/oval-def:metadata/oval-def:title"/>
        <xsl:variable name="result" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/@result"/>
        
         <xsl:variable name="fileContentTest_id1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[1]/@id"/>
        <xsl:variable name="result1" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id1]/@result"/>
       
       <xsl:variable name="fileContentTest_id2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/ind-def:textfilecontent54_test[2]/@id"/>
        <xsl:variable name="result2" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definitionId]/descendant::oval-res:criterion[@test_ref=$fileContentTest_id2]/@result"/>

        <xsl:variable name="state1" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[1]/ind-def:subexpression/text()"/>
        <xsl:variable name="state2" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[2]/ind-def:subexpression/text()"/>
        <xsl:variable name="state3" select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/ind-def:textfilecontent54_state[3]/ind-def:subexpression/text()"/>
        <xsl:variable name="actualVersion" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-sc:oval_system_characteristics/oval-sc:system_data/ind-sc:textfilecontent_item/ind-sc:subexpression/text()"/>
                
        
        <xsl:variable name="expectedVersion" >
            <xsl:choose>
                <xsl:when test="$state3 != '' ">
                    <xsl:value-of select="$state3"/>
                </xsl:when>
                <xsl:when test="$state2 != '' ">
                    <xsl:value-of select="$state2"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$state1"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>        
          
        
        <xsl:variable name="product">
            <xsl:call-template name="getProductNameFromTitle">
                <xsl:with-param name="title" select="$title"/>            
            </xsl:call-template>
        </xsl:variable>
      
        <xsl:variable name="isViolationValue">
            <xsl:choose>
             <xsl:when test="$result='false'">
                    <xsl:text>false</xsl:text>
                </xsl:when>
                <xsl:when test="$result = 'true' ">
                    <xsl:text>true</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
        
        <xsl:variable name="message_id">
            <xsl:choose>
                <xsl:when test="$result1='false'">
                    <xsl:text>com.mcafee.pa.msg.MacPatchNotApplicable</xsl:text>
                </xsl:when>
                <xsl:when test="$result='true' ">
                    <xsl:text>com.mcafee.pa.msg.MacSecUpdateStatus</xsl:text>
                </xsl:when>
                <xsl:when test="$result2='false'">
                    <xsl:text>com.mcafee.pa.msg.MacSecUpdateStatus</xsl:text>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
          
        <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="id">
                <xsl:value-of select="$definitionId"/>
            </xsl:attribute>
            <xsl:element name="finding" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="messageId">
                    <xsl:value-of select="$message_id"/>
                </xsl:attribute>
                <xsl:attribute name="isViolation">
                    <xsl:value-of select="$isViolationValue"/>
                </xsl:attribute>
                 <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                     <xsl:attribute name="key">product</xsl:attribute>
                     <xsl:value-of select="$product"/>
                </xsl:element>
             <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">expectedVersion</xsl:attribute>
                 <xsl:value-of select="$expectedVersion"/>
             </xsl:element>
                <xsl:element name="instanceValue" namespace="http://results.pa.mcafee.com/findings/5.2">
                    <xsl:attribute name="key">actualVersion</xsl:attribute>
                    <xsl:value-of select="$actualVersion"/>
                </xsl:element>
          </xsl:element>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>

