<xsl:stylesheet version="1.0" xmlns:oval-def="http://oval.mitre.org/XMLSchema/oval-definitions-5"
    xmlns:unix-def="http://oval.mitre.org/XMLSchema/oval-definitions-5#unix"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:cdf="http://checklists.nist.gov/xccdf/1.1" xmlns:xsd="http://www.w3.org/2001/XMLSchema"
    xmlns:oval-res="http://oval.mitre.org/XMLSchema/oval-results-5"
    xmlns:oval-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5"
    xmlns:unix-sc="http://oval.mitre.org/XMLSchema/oval-system-characteristics-5#unix"
    exclude-result-prefixes="oval-def xsl cdf xsd oval-res oval-sc unix-sc unix-def">
    <xsl:output method="xml" indent="yes" omit-xml-declaration="yes"/>
    
    <xsl:template name="fileWriteProtectDefinition">
        <xsl:param name="definition_id"/>
        
        <xsl:variable name="result"
            select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/@result"/>
        <xsl:if test="$result='false'">
            <xsl:element name="findings" namespace="http://results.pa.mcafee.com/findings/5.2">
                <xsl:attribute name="id"><xsl:value-of select="$definition_id"/></xsl:attribute>
                <xsl:variable name="test_id" select="/oval-res:oval_results/oval-res:results/oval-res:system/oval-res:definitions/oval-res:definition[@definition_id=$definition_id]/descendant::oval-res:criterion[1]/@test_ref"/>
                <xsl:call-template name="fileWriteProtectTest">
                    <xsl:with-param name="test_Id" select="$test_id"/>
                </xsl:call-template>
            </xsl:element>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="fileWriteProtectTest">
        <xsl:param name="test_Id"/>
        <xsl:variable name="state_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:state/@state_ref"/>
        <xsl:variable name="state"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:states/unix-def:file_state[@id=$state_id]"/>
        <xsl:variable name="obj_id"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:tests/unix-def:file_test[@id=$test_Id]/unix-def:object/@object_ref"/>
        <xsl:variable name="object"
            select="/oval-res:oval_results/oval-def:oval_definitions/oval-def:objects/unix-def:file_object[@id=$obj_id]"/>
        <xsl:variable name="path" select="$object/unix-def:path/text()"/>
        <xsl:variable name="filename" select="$object/unix-def:filename"/>
        <xsl:element name="inputValue" namespace="http://results.pa.mcafee.com/findings/5.2">
            <xsl:attribute name="key">filename</xsl:attribute>
            <xsl:call-template name="combinePaths">
                <xsl:with-param name="first" select="$path" />
                <xsl:with-param name="second" select="$filename" />
            </xsl:call-template>
        </xsl:element>
        <!-- Message 'The file ##filename## should not be world writeable' -->
        <xsl:element namespace="http://results.pa.mcafee.com/findings/5.2" name="finding">
            <xsl:attribute name="messageId">com.mcafee.pa.msg.unixfilewriteprot0</xsl:attribute>
            <xsl:attribute name="isViolation">true</xsl:attribute>
        </xsl:element>
    </xsl:template>
    <xsl:include href="unixUtils.xsl"/>
</xsl:stylesheet>